﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace CSV_Reader
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void getScoresButton_Click(object sender, EventArgs e)
        {
            try
            {
                StreamReader inputFile; // Zmienna pozwalająca na odczytanie danych z pliku.
                string line;            // Zmienna przechowująca wiersz odczytany z pliku.
                int count = 0;          // Zmienna licznika uczniów.
                int total;              // Zmienna akumulatora.
                double average;         // Zmienna przechowująca średni wynik ze sprawdzianów.

                // Utworzenie tablicy ogranicznika.
                char[] delim = { ',' };

                // Otworzenie pliku w formacie CSV.
                inputFile = File.OpenText("Grades.csv");

                while (!inputFile.EndOfStream)
                {
                    // Inkrementacja zmiennej licznika uczniów.
                    count++;

                    // Odczyt wiersza z pliku.
                    line = inputFile.ReadLine();

                    // Pobranie wyników ze sprawdzianów i użycie ich jako tokenów.
                    string[] tokens = line.Split(delim);

                    // Przypisanie zmiennej akumulatora wartości 0.
                    total = 0;

                    // Obliczenie sumy tokenów
                    // wyników ze sprawdzianów.
                    foreach (string str in tokens)
                    {
                        total += int.Parse(str);
                    }

                    // Obliczenie średniego
                    // wyniku ze sprawdzianów.
                    average = (double)total / tokens.Length;

                    // Wyświetlenie obliczonej wartości średniej.
                    averagesListBox.Items.Add("Średni wynik ucznia nr " +
                        count + " wynosi " + average.ToString("n1"));
                }

                // Zamknięcie pliku.
                inputFile.Close();
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show(ex.Message);
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
